/*
 * Decompiled with CFR 0.152.
 */
package com.mujmajnkraft.bettersurvival.config;

import com.mujmajnkraft.bettersurvival.BetterSurvival;
import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.apache.logging.log4j.Level;

@Config(modid="mujmajnkraftsbettersurvival")
public class ForgeConfigHandler {
    @Config.Comment(value={"Weapon Config (server)"})
    @Config.Name(value="Weapons")
    public static final WeaponConfig weapons = new WeaponConfig();
    @Config.Comment(value={"Potion Config (server)"})
    @Config.Name(value="Potions")
    public static final PotionConfig potions = new PotionConfig();
    @Config.Comment(value={"Enchantment Config (server)"})
    @Config.Name(value="Enchantments")
    public static final EnchantmentConfig enchantments = new EnchantmentConfig();
    @Config.Comment(value={"Material Config (server)"})
    @Config.Name(value="Materials")
    public static final MaterialConfig materials = new MaterialConfig();
    @Config.Comment(value={"Client Config"})
    @Config.Name(value="Client")
    public static final ClientConfig client = new ClientConfig();

    @Mod.EventBusSubscriber(modid="mujmajnkraftsbettersurvival")
    private static class EventHandler {
        private EventHandler() {
        }

        @SubscribeEvent
        public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
            if (event.getModID().equals("mujmajnkraftsbettersurvival")) {
                potions.refreshCache();
                ConfigManager.sync((String)"mujmajnkraftsbettersurvival", (Config.Type)Config.Type.INSTANCE);
            }
        }
    }

    public static class ClientConfig {
        @Config.Comment(value={"Prevent custom shields from messing up your FoV. This will cause problems with other mods that change FoV."})
        @Config.Name(value="Custom Shield FOV")
        public boolean fovShields = true;
        @Config.Comment(value={"Prevent FoV changes completely."})
        @Config.Name(value="Static FOV")
        public boolean staticFOV = false;
    }

    public static class WeaponConfig {
        final String damageModifierDesc = "Set damage stat modifere for the weapon";
        final String speedModifierDesc = "Set speed stat modifere for the weapon";
        @Config.Comment(value={"Extra attack reach given to spears."})
        @Config.Name(value="Extra reach base")
        @Config.RequiresMcRestart
        public float spearReachBonus = 2.0f;
        @Config.Comment(value={"Chance per full-strength hammer hit that Stun procs."})
        @Config.Name(value="Stun Base Chance")
        public float stunBaseChance = 0.1f;
        @Config.Comment(value={"Increased Stun chance per level of Bash"})
        @Config.Name(value="Bash Stun Modifier")
        public float bashModifier = 0.05f;
        @Config.Comment(value={"Chance per full-strength battleaxe hit that Disarm procs."})
        @Config.Name(value="Disarm Base Chance")
        public float disarmBaseChance = 0.1f;
        @Config.Comment(value={"Increased Disarm chance per level of Disarming"})
        @Config.Name(value="Disarming chance Modifier")
        public float disarmModifier = 0.05f;
        @Config.Comment(value={"Set damage stat modifere for the weapon"})
        @Config.Name(value="Battle Axe damage modifier")
        @Config.RequiresMcRestart
        public float battleAxeDmgMod = 1.6f;
        @Config.Comment(value={"Set damage stat modifere for the weapon"})
        @Config.Name(value="Nunchaku damage modifier")
        @Config.RequiresMcRestart
        public float nunchakuDmgMod = 0.5f;
        @Config.Comment(value={"Set damage stat modifere for the weapon"})
        @Config.Name(value="Hammer damage modifier")
        @Config.RequiresMcRestart
        public float hammerDmgMod = 1.2f;
        @Config.Comment(value={"Set damage stat modifere for the weapon"})
        @Config.Name(value="Dagger damage modifier")
        @Config.RequiresMcRestart
        public float daggerDmgMod = 0.7f;
        @Config.Comment(value={"Set damage stat modifere for the weapon"})
        @Config.Name(value="Spear damage")
        @Config.RequiresMcRestart
        public float spearDmgMod = 0.75f;
        @Config.Comment(value={"Set damage stat modifere for the weapon"})
        @Config.Name(value="Crossbow damage")
        public float crossbowDmgMod = 2.0f;
        @Config.Comment(value={"Set speed stat modifere for the weapon"})
        @Config.Name(value="Battle Axe attack delay")
        @Config.RequiresMcRestart
        public float battleAxeSpd = 1.25f;
        @Config.Comment(value={"Set speed stat modifere for the weapon"})
        @Config.Name(value="Nunchaku attack delay")
        @Config.RequiresMcRestart
        public float nunchakuSpd = 0.3f;
        @Config.Comment(value={"Set speed stat modifere for the weapon"})
        @Config.Name(value="Hammer attack delay")
        @Config.RequiresMcRestart
        public float hammerSpd = 1.35f;
        @Config.Comment(value={"Set speed stat modifere for the weapon"})
        @Config.Name(value="Dagger attack delay")
        @Config.RequiresMcRestart
        public float daggerSpd = 0.8f;
        @Config.Comment(value={"Set speed stat modifere for the weapon"})
        @Config.Name(value="Spear attack delay")
        @Config.RequiresMcRestart
        public float spearSpd = 1.0f;
        @Config.Comment(value={"Set speed stat modifere for the weapon"})
        @Config.Name(value="Crossbow realoding time")
        public int crossbowSpd = 40;
        @Config.Comment(value={"When set to false, disable Vanilla shield recipe, forcing player to use this mod's shields."})
        @Config.Name(value="Allow Vanilla Shields")
        @Config.RequiresMcRestart
        public boolean allowVanillaShields = true;
    }

    public static class MaterialConfig {
        @Config.Comment(value={"Allows you to craft weapons from materials from other mods."})
        @Config.Name(value="Modded materials")
        @Config.RequiresMcRestart
        public boolean moddedMaterials = true;
        @Config.Comment(value={"Set stats of copper material (harvest level, durability, efficiency, damage, enchantability)"})
        @Config.Name(value="Copper stats")
        @Config.RequiresMcRestart
        public Double[] copperStats = new Double[]{1.0, 160.0, 5.0, 1.0, 5.0};
        @Config.Comment(value={"Set stats of copper material (harvest level, durability, efficiency, damage, enchantability)"})
        @Config.Name(value="Brone stats")
        @Config.RequiresMcRestart
        public Double[] bronzeStats = new Double[]{2.0, 200.0, 6.0, 1.8, 14.0};
        @Config.Comment(value={"Set stats of invar material (harvest level, durability, efficiency, damage, enchantability)"})
        @Config.Name(value="Invar stats")
        @Config.RequiresMcRestart
        public Double[] invarStats = new Double[]{2.0, 250.0, 6.5, 2.1, 10.0};
        @Config.Comment(value={"Set stats of silver material (harvest level, durability, efficiency, damage, enchantability)"})
        @Config.Name(value="Silver stats")
        @Config.RequiresMcRestart
        public Double[] silverStats = new Double[]{0.0, 32.0, 12.0, 0.5, 22.0};
        @Config.Comment(value={"Set stats of electrum material (harvest level, durability, efficiency, damage, enchantability)"})
        @Config.Name(value="Electrum stats")
        @Config.RequiresMcRestart
        public Double[] electrumStats = new Double[]{0.0, 32.0, 15.0, 0.6, 35.0};
        @Config.Comment(value={"Set stats of aluminium material (harvest level, durability, efficiency, damage, enchantability)"})
        @Config.Name(value="Aluminium stats")
        @Config.RequiresMcRestart
        public Double[] aluminiumStats = new Double[]{2.0, 220.0, 12.0, 1.8, 14.0};
        @Config.Comment(value={"Set stats of steel material (harvest level, durability, efficiency, damage, enchantability)"})
        @Config.Name(value="Steel stats")
        @Config.RequiresMcRestart
        public Double[] steelStats = new Double[]{2.0, 350.0, 6.5, 2.5, 14.0};
        @Config.Comment(value={"Set stats of signalum material (harvest level, durability, efficiency, damage, enchantability)"})
        @Config.Name(value="Signalum stats")
        @Config.RequiresMcRestart
        public Double[] signalumStats = new Double[]{2.0, 500.0, 10.0, 2.0, 14.0};
        @Config.Comment(value={"Set stats of limium material (harvest level, durability, efficiency, damage, enchantability)"})
        @Config.Name(value="Lumium stats")
        @Config.RequiresMcRestart
        public Double[] lumiumStats = new Double[]{2.0, 600.0, 12.0, 2.5, 14.0};
        @Config.Comment(value={"Set stats of enderium material (harvest level, durability, efficiency, damage, enchantability)"})
        @Config.Name(value="Enderium stats")
        @Config.RequiresMcRestart
        public Double[] enderiumStats = new Double[]{3.0, 1000.0, 10.0, 4.0, 20.0};
    }

    public static class PotionConfig {
        @Config.Comment(value={"How much should Blindness reduce mobs view distance (Percentage)"})
        @Config.Name(value="Blindness Strength")
        @Config.RangeDouble(min=0.0, max=100.0)
        public double blindnessStrength = 80.0;
        @Config.Comment(value={"Blacklist of mobs to not affect with Blindness."})
        @Config.Name(value="Blindness Blacklist")
        public String[] blindnessBlacklist = new String[]{""};
        @Config.Comment(value={"When applying a potion to a weapon, how many hits should a dose give on the weapon."})
        @Config.Name(value="Potion Hits Amount")
        @Config.RangeInt(min=1, max=256)
        public int potionHits = 64;
        @Config.Comment(value={"Maximum number of hits to apply to a weapon with repeated doses."})
        @Config.Name(value="Maximum Potion Hits")
        @Config.RangeInt(min=1, max=512)
        public int maximumPotionHits = 64;
        @Config.Comment(value={"When applying a potion to a weapon, what to divide the potion's time by for a single dose."})
        @Config.Name(value="Potion Timer Divider")
        @Config.RangeInt(min=1, max=256)
        public int potionDivisor = 8;
        @Config.Comment(value={"Whitelist of weapons classes that can have potions applied to them."})
        @Config.Name(value="Potion-Applying Weapon Whitelist")
        public String[] paWeaponWhitelist = new String[]{"net.minecraft.item.ItemSword", "com.mujmajnkraft.bettersurvival.items.ItemCustomWeapon"};
        @Config.Comment(value={"Blacklist of potions that can be applied to weapons."})
        @Config.Name(value="Potion-Applying Potion Blacklist")
        public String[] paPotionBlacklist = new String[]{""};
        private List<Class<?>> weaponWhitelist = null;

        public boolean isClassInstanceofWhitelistedWeapon(Class<?> clazz) {
            return potions.getWeaponWhitelistClasses().stream().anyMatch(w -> w.isAssignableFrom(clazz));
        }

        private List<Class<?>> getWeaponWhitelistClasses() {
            if (this.weaponWhitelist == null) {
                this.weaponWhitelist = new ArrayList();
                for (String name : this.paWeaponWhitelist) {
                    try {
                        this.weaponWhitelist.add(Class.forName(name));
                    }
                    catch (Exception ex) {
                        BetterSurvival.LOG.log(Level.WARN, "Failed to parse weapon whitelist entry: " + name);
                    }
                }
            }
            return this.weaponWhitelist;
        }

        public void refreshCache() {
            this.weaponWhitelist = null;
        }
    }

    public static class EnchantmentConfig {
        @Config.Name(value="Assassinate max level")
        @Config.RangeInt(min=0, max=10)
        public int assassinteLevel = 3;
        @Config.Name(value="Agility max level")
        @Config.RangeInt(min=0, max=10)
        public int agilityLevel = 2;
        @Config.Name(value="Arrow Recovery max level")
        @Config.RangeInt(min=0, max=10)
        public int arrowRecoveryLevel = 3;
        @Config.Name(value="Bash max level")
        @Config.RangeInt(min=0, max=10)
        public int bashLevel = 3;
        @Config.Name(value="Blast max level")
        @Config.RangeInt(min=0, max=10)
        public int blastLevel = 2;
        @Config.Name(value="Blocking Power max level")
        @Config.RangeInt(min=0, max=10)
        public int blockingPowerLevel = 3;
        @Config.Name(value="Combo max level")
        @Config.RangeInt(min=0, max=10)
        public int comboLevel = 3;
        @Config.Name(value="Diamonds Everywhere max level")
        @Config.RangeInt(min=0, max=10)
        public int diamondsEverywhereLevel = 3;
        @Config.Name(value="Disarm max level")
        @Config.RangeInt(min=0, max=10)
        public int disarmLevel = 1;
        @Config.Name(value="Education max level")
        @Config.RangeInt(min=0, max=10)
        public int educationLevel = 3;
        @Config.Name(value="Fling max level")
        @Config.RangeInt(min=0, max=10)
        public int flingLevel = 2;
        @Config.Name(value="Heavy max level")
        @Config.RangeInt(min=0, max=10)
        public int heavyLevel = 1;
        @Config.Name(value="High Jump max level")
        @Config.RangeInt(min=0, max=10)
        public int highJumpLevel = 2;
        @Config.Name(value="Multishot max level")
        @Config.RangeInt(min=0, max=10)
        public int multishotLevel = 3;
        @Config.Name(value="Penetration max level")
        @Config.RangeInt(min=0, max=10)
        public int penetrationLevel = 5;
        @Config.Name(value="Range max level")
        @Config.RangeInt(min=0, max=10)
        public int rangeLevel = 1;
        @Config.Name(value="Rapid Fire max level")
        @Config.RangeInt(min=0, max=10)
        public int rapidFireLevel = 5;
        @Config.Name(value="Reflection max level")
        @Config.RangeInt(min=0, max=10)
        public int reflectionLevel = 3;
        @Config.Name(value="Smelting max level")
        @Config.RangeInt(min=0, max=10)
        public int smeltingLevel = 1;
        @Config.Name(value="Spell Shield max level")
        @Config.RangeInt(min=0, max=10)
        public int spellShieldLevel = 3;
        @Config.Name(value="Tunneling max level")
        @Config.RangeInt(min=0, max=10)
        public int tunnelingLevel = 2;
        @Config.Name(value="Vampirism max level")
        @Config.RangeInt(min=0, max=10)
        public int vampirismLevel = 1;
        @Config.Name(value="Versatility max level")
        @Config.RangeInt(min=0, max=10)
        public int versatilityLevel = 1;
        @Config.Name(value="Vitality max level")
        @Config.RangeInt(min=0, max=10)
        public int vitalityLevel = 1;
        @Config.Name(value="Weightless max level")
        @Config.RangeInt(min=0, max=10)
        public int weightlessLevel = 1;
        @Config.Comment(value={"Whether or not is this enchantment a treasure enchantment (exclusive to loot and trading)."})
        @Config.Name(value="Assassinate treasure")
        public boolean assassinteTreasure = false;
        @Config.Comment(value={"Whether or not is this enchantment a treasure enchantment (exclusive to loot and trading)."})
        @Config.Name(value="Agility treasure")
        public boolean agilityTreasure = false;
        @Config.Comment(value={"Whether or not is this enchantment a treasure enchantment (exclusive to loot and trading)."})
        @Config.Name(value="Arrow Recovery treasure")
        public boolean arrowRecoveryTreasure = false;
        @Config.Comment(value={"Whether or not is this enchantment a treasure enchantment (exclusive to loot and trading)."})
        @Config.Name(value="Bash treasure")
        public boolean bashTreasure = false;
        @Config.Comment(value={"Whether or not is this enchantment a treasure enchantment (exclusive to loot and trading)."})
        @Config.Name(value="Blast treasure")
        public boolean blastTreasure = false;
        @Config.Comment(value={"Whether or not is this enchantment a treasure enchantment (exclusive to loot and trading)."})
        @Config.Name(value="Blocking Power treasure")
        public boolean blockingPowerTreasure = false;
        @Config.Comment(value={"Whether or not is this enchantment a treasure enchantment (exclusive to loot and trading)."})
        @Config.Name(value="Combo treasure")
        public boolean comboTreasure = false;
        @Config.Comment(value={"Whether or not is this enchantment a treasure enchantment (exclusive to loot and trading)."})
        @Config.Name(value="Diamonds Everywhere treasure")
        public boolean diamondsEverywhereTreasure = false;
        @Config.Comment(value={"Whether or not is this enchantment a treasure enchantment (exclusive to loot and trading)."})
        @Config.Name(value="Disarm treasure")
        public boolean disarmTreasure = false;
        @Config.Comment(value={"Whether or not is this enchantment a treasure enchantment (exclusive to loot and trading)."})
        @Config.Name(value="Education treasure")
        public boolean educationTreasure = false;
        @Config.Comment(value={"Whether or not is this enchantment a treasure enchantment (exclusive to loot and trading)."})
        @Config.Name(value="Fling treasure")
        public boolean flingTreasure = false;
        @Config.Comment(value={"Whether or not is this enchantment a treasure enchantment (exclusive to loot and trading)."})
        @Config.Name(value="Heavy treasure")
        public boolean heavyTreasure = false;
        @Config.Comment(value={"Whether or not is this enchantment a treasure enchantment (exclusive to loot and trading)."})
        @Config.Name(value="High Jump treasure")
        public boolean highJumpTreasure = false;
        @Config.Comment(value={"Whether or not is this enchantment a treasure enchantment (exclusive to loot and trading)."})
        @Config.Name(value="Multishot treasure")
        public boolean multishotTreasure = false;
        @Config.Comment(value={"Whether or not is this enchantment a treasure enchantment (exclusive to loot and trading)."})
        @Config.Name(value="Penetration treasure")
        public boolean penetrationTreasure = false;
        @Config.Comment(value={"Whether or not is this enchantment a treasure enchantment (exclusive to loot and trading)."})
        @Config.Name(value="Range treasure")
        public boolean rangeTreasure = false;
        @Config.Comment(value={"Whether or not is this enchantment a treasure enchantment (exclusive to loot and trading)."})
        @Config.Name(value="Rapid Fire treasure")
        public boolean rapidFireTreasure = false;
        @Config.Comment(value={"Whether or not is this enchantment a treasure enchantment (exclusive to loot and trading)."})
        @Config.Name(value="Reflection treasure")
        public boolean reflectionTreasure = false;
        @Config.Comment(value={"Whether or not is this enchantment a treasure enchantment (exclusive to loot and trading)."})
        @Config.Name(value="Smelting treasure")
        public boolean smeltingTreasure = false;
        @Config.Comment(value={"Whether or not is this enchantment a treasure enchantment (exclusive to loot and trading)."})
        @Config.Name(value="Spell Shield treasure")
        public boolean spellShieldTreasure = false;
        @Config.Comment(value={"Whether or not is this enchantment a treasure enchantment (exclusive to loot and trading)."})
        @Config.Name(value="Tunneling treasure")
        public boolean tunnelingTreasure = false;
        @Config.Comment(value={"Whether or not is this enchantment a treasure enchantment (exclusive to loot and trading)."})
        @Config.Name(value="Vampirism treasure")
        public boolean vampirismTreasure = false;
        @Config.Comment(value={"Whether or not is this enchantment a treasure enchantment (exclusive to loot and trading)."})
        @Config.Name(value="Versatility treasure")
        public boolean versatilityTreasure = false;
        @Config.Comment(value={"Whether or not is this enchantment a treasure enchantment (exclusive to loot and trading)."})
        @Config.Name(value="Vitality treasure")
        public boolean vitalityTreasure = false;
        @Config.Comment(value={"Whether or not is this enchantment a treasure enchantment (exclusive to loot and trading)."})
        @Config.Name(value="Weightless treasure")
        public boolean weightlessTreasure = false;
        @Config.Comment(value={"Multiplier of arrow velocity for the Range enchantment."})
        @Config.Name(value="Range Multiplier")
        @Config.RangeDouble(min=1.0, max=10.0)
        public double rangeVelocity = 1.5;
        @Config.Comment(value={"Prevent Tunneling enchantment from attempting to mine TileEntities."})
        @Config.Name(value="Tunneling ignores TileEntities")
        public boolean preventTunnelingTileEntities = true;
    }
}

